<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class Schnellbuchung
 *
 * @package Vtours\Website\Model\Stage
 */
class Schnellbuchung extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'schnellbuchung.twig';

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $hideAirport;

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Schnellbuchung
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return string
     */
    public function getHideAirport()
    {
        return $this->hideAirport;
    }

    /**
     * @param string $hideAirport
     * @return Schnellbuchung
     */
    public function setHideAirport($hideAirport)
    {
        $this->hideAirport = $hideAirport;
        return $this;
    }


}
