<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneAkkordeon;
use Vtours\Website\Model\Stage\Akkordeon;
use Vtours\Website\Model\Stage\Element\TitleText;

/**
 * Class StageAccordion
 *
 * @package Vtours\Website\Mapper
 */
class StageAccordion implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneAkkordeon;
    }

    /**
     * handle
     *
     * @param VtoursBuehneAkkordeon $object
     * @param string                $language
     *
     * @return Akkordeon
     */
    public function handle($object, $language)
    {
        $elements = $object->getElements($language);

        $titleTextElements = [];
        foreach ($elements as $element) {
            $titleTextElements[] = (new TitleText())
                ->setTitle($element['title']->getData())
                ->setContent($element['content']->getData());
        }

        return (new Akkordeon())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setFirstElementActivated($object->getFirstElementActivated($language))
            ->setElements($titleTextElements);
    }

}
