<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneEmpfehlungen;
use Pimcore\Model\Object\VtoursElementTestimonial;
use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Testimonial;
use Vtours\Website\Model\Stage\Empfehlungen;

/**
 * Class StageEmpfehlungen
 *
 * @package Vtours\Website\Mapper
 */
class StageEmpfehlungen implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneEmpfehlungen;
    }

    /**
     * handle
     *
     * @param VtoursBuehneEmpfehlungen $object
     * @param string                   $language
     *
     * @return Empfehlungen
     */
    public function handle($object, $language)
    {

        /**
         * @todo check published
         */
        $testimonialArray = $object->getTestimonial();

        $picture = new Image();
        if ($testimonialArray[0] instanceof VtoursElementTestimonial && !empty($testimonialArray[0]->getPicture())) {
            $picture->build($testimonialArray[0]->getPicture(), $language);
        }

        $testimonial = (new Testimonial())
            ->setName($testimonialArray[0]->getName())
            ->setPicture($picture)
            ->setContent($testimonialArray[0]->getContent($language));

        $pictureXS = new Image();
        if (!empty($object->getBackgroundPictureXS())) {
            $pictureXS->build($object->getBackgroundPictureXS(), $language);
        }

        $pictureSM = new Image();
        if (!empty($object->getBackgroundPictureSM())) {
            $pictureSM->build($object->getBackgroundPictureSM(), $language);
        }

        $pictureMD = new Image();
        if (!empty($object->getBackgroundPictureMD())) {
            $pictureMD->build($object->getBackgroundPictureMD(), $language);
        }

        $pictureLG = new Image();
        if (!empty($object->getBackgroundPictureLG())) {
            $pictureLG->build($object->getBackgroundPictureLG(), $language);
        }

        $offers = [];
        if (!empty($object->getOffer())) {
            foreach ($object->getOffer() as $offer) {
                $offers[] = (new Angebot())->build($offer, $language);

            }
        }

        return (new Empfehlungen())
            ->setObjectId($object->getId())
            ->setPosition($object->getTestimonialPosition())
            ->setShowArrow($object->getShowArrow())
            ->setTestimonial($testimonial)
            ->setBackgroundPictureXS($pictureXS)
            ->setBackgroundPictureSM($pictureSM)
            ->setBackgroundPictureMD($pictureMD)
            ->setBackgroundPictureLG($pictureLG)
            ->setOffer($offers);
    }
}
