<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;

/**
 * Class Reisetipps
 *
 * @package Vtours\Website\Model\Stage
 */
class Reisetipps extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'reisetipps.twig';

    /**
     * @var Image
     */
    private $startPicture;

    /**
     * @var Image
     */
    private $endPicture;

    /**
     * @var \Vtours\Website\Model\Stage\Element\InspirationElement[]
     */
    private $tips;


    /**
     * @return Image
     */
    public function getStartPicture()
    {
        return $this->startPicture;
    }

    /**
     * @param Image $startPicture
     *
     * @return Reisetipps
     */
    public function setStartPicture($startPicture)
    {
        $this->startPicture = $startPicture;

        return $this;
    }

    /**
     * @return Image
     */
    public function getEndPicture()
    {
        return $this->endPicture;
    }

    /**
     * @param Image $endPicture
     *
     * @return Reisetipps
     */
    public function setEndPicture($endPicture)
    {
        $this->endPicture = $endPicture;

        return $this;
    }

    /**
     * @return Element\InspirationElement[]
     */
    public function getTips()
    {
        return $this->tips;
    }

    /**
     * @param Element\InspirationElement[] $tips
     *
     * @return Reisetipps
     */
    public function setTips($tips)
    {
        $this->tips = $tips;

        return $this;
    }
}
