<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneKontaktFormular;
use Vtours\Website\Model\Stage\KontaktFormular;

/**
 * Class StageContactForm
 *
 * @package Vtours\Website\Mapper
 */
class StageContactForm implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneKontaktFormular;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {

        $bookingSourceOptions = $object->getBookingSourceOptions($language);

        $bookingOptionsArray = [];
        if (!empty($bookingSourceOptions)) {
            foreach ($bookingSourceOptions as $bookingSourceOption) {
                $bookingOptionsArray[] = $bookingSourceOption['bookingSourceOption']->getData();
            }
        }


        $subjectOptions = $object->getSubjectOptions($language);

        $subjectOptionsArray = [];
        if (!empty($subjectOptions)) {
            foreach ($subjectOptions as $subjectOption) {
                $subjectOptionsArray[] = $subjectOption['subjectOption']->getData();
            }
        }

        return (new KontaktFormular())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setSalutation($object->getSalutation($language))
            ->setLabelChoose($object->getLabelChoose($language))
            ->setSalutationMr($object->getSalutationMr($language))
            ->setSalutationMs($object->getSalutationMs($language))
            ->setFirstName($object->getFirstName($language))
            ->setLastName($object->getLastName($language))
            ->setEmail($object->getEmail($language))
            ->setTelephone($object->getTelefon($language))
            ->setFax($object->getFax($language))
            ->setBookingSource($object->getBookingSource($language))
            ->setBookingSourceOptions($bookingOptionsArray)
            ->setBookingNumber($object->getBookingNumber($language))
            ->setSubject($object->getSubject($language))
            ->setSubjectOptions($subjectOptionsArray)
            ->setMessage($object->getMessage($language))
            ->setLabelButton($object->getLabelButton($language));
    }
}
