<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneIframe;
use Vtours\Website\Model\Stage\Iframe;

/**
 * Class StageIframe
 *
 * @package Vtours\Website\Mapper\Handler
 */
class StageIframe implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneIframe;
    }

    /**
     * handle
     *
     * @param VtoursBuehneIframe $object
     * @param string             $language
     *
     * @return Iframe
     */
    public function handle($object, $language)
    {
        return (new Iframe())
            ->setObjectId($object->getId())
            ->setUrl($object->getUrl())
            ->setQueryParam($object->getQueryParam())
            ->setAutoheight($object->getAutoheight());
    }

}
