<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneServiceMitarbeiter;
use Vtours\Website\Model\Stage\Element\Employee;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Mitarbeiter;

/**
 * Class StageServiceStaff
 *
 * @package Vtours\Website\Mapper
 */
class StageServiceStaff implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneServiceMitarbeiter;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $callCenterStaff = $object->getElements($language);

        /**
         * VtoursBuehneServiceMitarbeiterElement $staff
         */
        $employeeArray = [];
        foreach ($callCenterStaff as $staff) {

            $image = (new Image())->build($staff->getPicture(), $language);

            $employeeArray[] = (new Employee())
                ->setPicture($image)
                ->setName($staff->getName())
                ->setPosition($staff->getPosition($language));
        }

        return (new Mitarbeiter())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setDescription($object->getDescription($language))
            ->setElements($employeeArray);
    }
}
