<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper;

use Vtours\Website\Mapper\Handler\StageAccordion;
use Vtours\Website\Mapper\Handler\StageBeschwerdeFormular;
use Vtours\Website\Mapper\Handler\StageBildLink;
use Vtours\Website\Mapper\Handler\StageBreadcrumb;
use Vtours\Website\Mapper\Handler\StageContactForm;
use Vtours\Website\Mapper\Handler\StageCountdown;
use Vtours\Website\Mapper\Handler\StageEmpfehlungen;
use Vtours\Website\Mapper\Handler\StageFooterInformationBar;
use Vtours\Website\Mapper\Handler\StageFormular;
use Vtours\Website\Mapper\Handler\StageHero;
use Vtours\Website\Mapper\Handler\StageHtmlContent;
use Vtours\Website\Mapper\Handler\StageIframe;
use Vtours\Website\Mapper\Handler\StageInformation;
use Vtours\Website\Mapper\Handler\StageInspiration;
use Vtours\Website\Mapper\Handler\StageNewsletter;
use Vtours\Website\Mapper\Handler\StagePromise;
use Vtours\Website\Mapper\Handler\StageReisetipps;
use Vtours\Website\Mapper\Handler\StageReisezieleListeKarte;
use Vtours\Website\Mapper\Handler\StageReisezieleZusatzInfo;
use Vtours\Website\Mapper\Handler\StageSchnellbuchung;
use Vtours\Website\Mapper\Handler\StageService;
use Vtours\Website\Mapper\Handler\StageServiceStaff;
use Vtours\Website\Mapper\Handler\StageText;
use Vtours\Website\Mapper\Handler\StageTextBild;
use Vtours\Website\Mapper\Handler\StageTextButton;
use Vtours\Website\Mapper\Handler\StageTextZweispaltigAufzaehlung;
use Vtours\Website\Mapper\Handler\StageTextMehrspaltig;
use Vtours\Website\Mapper\Handler\StageTopLeiste;
use Vtours\Website\Mapper\Handler\StageTravelDestinationSlider;
use Vtours\Website\Mapper\Handler\StageVfamilyAngebote;

/**
 * Class StageMapper
 *
 * @package VtoursWebsiteExport\Helper
 */
class StageMapper
{

    /**
     * @var Context
     */
    private $context;

    /**
     * StageMapper constructor.
     */
    public function __construct()
    {

        $this->context =
            (new Context())
                ->addHandler(new StageAccordion())
                ->addHandler(new StageBildLink())
                ->addHandler(new StageContactForm())
                ->addHandler(new StageEmpfehlungen())
                ->addHandler(new StageFooterInformationBar())
                ->addHandler(new StageHero())
                ->addHandler(new StageHtmlContent())
                ->addHandler(new StageInformation())
                ->addHandler(new StagePromise())
                ->addHandler(new StageReisezieleListeKarte())
                ->addHandler(new StageReisezieleZusatzInfo())
                ->addHandler(new StageService())
                ->addHandler(new StageServiceStaff())
                ->addHandler(new StageText())
                ->addHandler(new StageTextBild())
                ->addHandler(new StageTextButton())
                ->addHandler(new StageTextMehrspaltig())
                ->addHandler(new StageTextZweispaltigAufzaehlung())
                ->addHandler(new StageTopLeiste())
                ->addHandler(new StageTravelDestinationSlider())
                ->addHandler(new StageBreadcrumb())
                ->addHandler(new StageNewsletter())
                ->addHandler(new StageIframe())
                ->addHandler(new StageVfamilyAngebote())
                ->addHandler(new StageSchnellbuchung())
                ->addHandler(new StageCountdown())
                ->addHandler(new StageReisetipps())
                ->addHandler(new StageInspiration())
                ->addHandler(new StageFormular())
                ->addHandler(new StageBeschwerdeFormular());
    }

    /**
     * handle
     *
     * @param        $object
     * @param string $language
     *
     * @return mixed
     */
    public function handle($object, $language)
    {
        return $this->context->handle($object, $language);
    }
}
