<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;

/**
 * Class BildLink
 *
 * @package Vtours\Website\Model\Stage
 */
class BildLink extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'bild-link.twig';

    /**
     * @var string
     */
    private $linkText;

    /**
     * @var Link
     */
    private $link;

    /**
     * @var string
     */
    private $layout;

    /**
     * @var Image
     */
    private $backgroundPictureXS;

    /**
     * @var Image
     */
    private $backgroundPictureSM;

    /**
     * @var Image
     */
    private $backgroundPictureMD;

    /**
     * @var Image
     */
    private $backgroundPictureLG;

    /**
     * @return string
     */
    public function getLinkText()
    {
        return $this->linkText;
    }

    /**
     * @param string $linkText
     *
     * @return BildLink
     */
    public function setLinkText($linkText)
    {
        $this->linkText = $linkText;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @param Link $link
     *
     * @return BildLink
     */
    public function setLink($link)
    {
        $this->link = $link;

        return $this;
    }

    /**
     * @return string
     */
    public function getLayout()
    {
        return $this->layout;
    }

    /**
     * @param string $layout
     *
     * @return BildLink
     */
    public function setLayout($layout)
    {
        $this->layout = $layout;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureXS()
    {
        return $this->backgroundPictureXS;
    }

    /**
     * @param Image $backgroundPictureXS
     *
     * @return BildLink
     */
    public function setBackgroundPictureXS($backgroundPictureXS)
    {
        $this->backgroundPictureXS = $backgroundPictureXS;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureSM()
    {
        return $this->backgroundPictureSM;
    }

    /**
     * @param Image $backgroundPictureSM
     *
     * @return BildLink
     */
    public function setBackgroundPictureSM($backgroundPictureSM)
    {
        $this->backgroundPictureSM = $backgroundPictureSM;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureMD()
    {
        return $this->backgroundPictureMD;
    }

    /**
     * @param Image $backgroundPictureMD
     *
     * @return BildLink
     */
    public function setBackgroundPictureMD($backgroundPictureMD)
    {
        $this->backgroundPictureMD = $backgroundPictureMD;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureLG()
    {
        return $this->backgroundPictureLG;
    }

    /**
     * @param Image $backgroundPictureLG
     *
     * @return BildLink
     */
    public function setBackgroundPictureLG($backgroundPictureLG)
    {
        $this->backgroundPictureLG = $backgroundPictureLG;

        return $this;
    }

    /**
     * getBackgroundPicture
     *
     * @param string $size
     *
     * @return Image
     */
    public function getBackgroundPicture($size)
    {

        $size = strtolower($size);

        $picture = $this->backgroundPictureLG;

        if ($size == 'md' && !empty($this->backgroundPictureMD->getUrl())) {
            $picture = (empty($this->backgroundPictureMD->getUrl()) ? $this->backgroundPictureLG : $this->backgroundPictureMD);
        }

        if ($size == 'sm') {
            if (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        if ($size == 'xs') {
            if (!empty($this->backgroundPictureXS->getUrl())) {
                $picture = $this->backgroundPictureXS;
            } elseif (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        return $picture;
    }
}
