<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage\Element;

/**
 * Class InformationElement
 *
 * @package Vtours\Website\Model\Stage\Element
 */
class InformationElement
{

    /**
     * @var string
     */
    private $title;

    /**
     * @var Image
     */
    private $contentImage;

    /**
     * @var string
     */
    private $orientationContentImage;

    /**
     * @var string
     */
    private $content;

    /**
     * @var Image
     */
    private $additionalContentImage;

    /**
     * @var string
     */
    private $orientationAdditionalContentImage;

    /**
     * @var string
     */
    private $additionalContent;

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return InformationElement
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return Image
     */
    public function getContentImage()
    {
        return $this->contentImage;
    }

    /**
     * @param Image $contentImage
     *
     * @return InformationElement
     */
    public function setContentImage($contentImage)
    {
        $this->contentImage = $contentImage;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrientationContentImage()
    {
        return $this->orientationContentImage;
    }

    /**
     * @param string $orientationContentImage
     *
     * @return InformationElement
     */
    public function setOrientationContentImage($orientationContentImage)
    {
        $this->orientationContentImage = $orientationContentImage;

        return $this;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return InformationElement
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * @return Image
     */
    public function getAdditionalContentImage()
    {
        return $this->additionalContentImage;
    }

    /**
     * @param Image $additionalContentImage
     *
     * @return InformationElement
     */
    public function setAdditionalContentImage($additionalContentImage)
    {
        $this->additionalContentImage = $additionalContentImage;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrientationAdditionalContentImage()
    {
        return $this->orientationAdditionalContentImage;
    }

    /**
     * @param string $orientationAdditionalContentImage
     *
     * @return InformationElement
     */
    public function setOrientationAdditionalContentImage($orientationAdditionalContentImage)
    {
        $this->orientationAdditionalContentImage = $orientationAdditionalContentImage;

        return $this;
    }

    /**
     * @return string
     */
    public function getAdditionalContent()
    {
        return $this->additionalContent;
    }

    /**
     * @param string $additionalContent
     *
     * @return InformationElement
     */
    public function setAdditionalContent($additionalContent)
    {
        $this->additionalContent = $additionalContent;

        return $this;
    }
}
