<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Doctrine\Common\Collections\ArrayCollection;
use Vtours\Website\Model\Stage\Element\InspirationElement;

/**
 * Class Inspiration
 *
 * @package Vtours\Website\Model\Stage
 */
class Inspiration extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'inspiration.twig';

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $showMore;

    /**
     * @var string
     */
    private $circleContent;

    /**
     * @var ArrayCollection[]
     */
    private $line;

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Inspiration
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getShowMore()
    {
        return $this->showMore;
    }

    /**
     * @param mixed $showMore
     *
     * @return Inspiration
     */
    public function setShowMore($showMore)
    {
        $this->showMore = $showMore;

        return $this;
    }

    /**
     * @return string
     */
    public function getCircleContent()
    {
        return $this->circleContent;
    }

    /**
     * @param string $circleContent
     *
     * @return Inspiration
     */
    public function setCircleContent($circleContent)
    {
        $this->circleContent = $circleContent;

        return $this;
    }

    /**
     * @return ArrayCollection[]
     */
    public function getLine()
    {
        return $this->line;
    }

    /**
     * @param ArrayCollection[] $line
     *
     * @return Inspiration
     */
    public function setLine($line)
    {
        $this->line = $line;

        return $this;
    }

    /**
     * addToLine
     *
     * @param int                $number
     * @param InspirationElement $element
     */
    public function addToLine($number, InspirationElement $element)
    {
        if (empty($this->line[$number])) {
            $this->line[$number] = new ArrayCollection();
        }

        $this->line[$number]->add($element);
    }
}
