<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Employee;

/**
 * Class Mitarbeiter
 *
 * @package Vtours\Model\Stage
 */
class Mitarbeiter extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'mitarbeiter.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $description;

    /**
     * @var Employee[]
     */
    private $elements;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return Mitarbeiter
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     *
     * @return Mitarbeiter
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return Employee[]
     */
    public function getElements()
    {
        return $this->elements;
    }

    /**
     * @param Employee[] $elements
     *
     * @return Mitarbeiter
     */
    public function setElements($elements)
    {
        $this->elements = $elements;
        return $this;
    }
}
