<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class TextMehrspaltig
 *
 * @package Vtours\Website\Model\Stage
 */
class TextMehrspaltig extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'text-mehrspaltig.twig';

    /**
     * @var string
     */
    private $columns;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $introText;

    /**
     * @var array
     */
    private $enumeration;

    /**
     * @return string
     */
    public function getColumns()
    {
        return $this->columns;
    }

    /**
     * @param string $columns
     *
     * @return TextMehrspaltig
     */
    public function setColumns($columns)
    {
        $this->columns = $columns;

        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return TextMehrspaltig
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return array
     */
    public function getEnumeration()
    {
        return $this->enumeration;
    }

    /**
     * @param array $enumeration
     *
     * @return TextMehrspaltig
     */
    public function setEnumeration($enumeration)
    {
        $this->enumeration = $enumeration;

        return $this;
    }

    /**
     * @return string
     */
    public function getIntroText()
    {
        return $this->introText;
    }

    /**
     * @param string $introText
     *
     * @return TextMehrspaltig
     */
    public function setIntroText($introText)
    {
        $this->introText = $introText;

        return $this;
    }

}
