<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class TextZweispaltigAufzaehlung
 *
 * @package Vtours\Website\Model\Stage
 */
class TextZweispaltigAufzaehlung extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'text-zweispaltig-aufzaehlung.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var array
     */
    private $enumeration;

    /**
     * @var string
     */
    private $textLeft;

    /**
     * @var string
     */
    private $textRight;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return TextZweispaltigAufzaehlung
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return array
     */
    public function getEnumeration()
    {
        return $this->enumeration;
    }

    /**
     * @param array $enumeration
     *
     * @return TextZweispaltigAufzaehlung
     */
    public function setEnumeration($enumeration)
    {
        $this->enumeration = $enumeration;

        return $this;
    }

    /**
     * @return string
     */
    public function getTextLeft()
    {
        return $this->textLeft;
    }

    /**
     * @param string $textLeft
     *
     * @return TextZweispaltigAufzaehlung
     */
    public function setTextLeft($textLeft)
    {
        $this->textLeft = $textLeft;

        return $this;
    }

    /**
     * @return string
     */
    public function getTextRight()
    {
        return $this->textRight;
    }

    /**
     * @param string $textRight
     *
     * @return TextZweispaltigAufzaehlung
     */
    public function setTextRight($textRight)
    {
        $this->textRight = $textRight;

        return $this;
    }
}
